<?php

class Reservation {
    public $Title;
    public $FirstName;
    public $LastName;
    public $EmailAddress;
    public $Mobile;
    public $HomePhone;
    public $StreetName;
    public $City;
    public $Postcode;
    public $StateProvince;
    public $Country;
    public $CompanyName;
    public $RoomType;
    public $RoomNumber;
    public $GuestNumberAdults;
    public $GuestNumberChildren;
    public $CheckInDate;
    public $CheckOutDate;
    public $ArrivalFlightNo;
    public $AirportTransportRequired;
    public $Comments;
    public $PaymentMethod;

    /**
     * setDetails - set the details based on array of details
     * @param array - array of values to set for class
     */
    public function setDetails($details) {
        foreach ($details as $property => $value) {
            $function = 'set' . $property;
            if (method_exists($this, $function)) {
                $this->$function($value);
            }
        }
    }

    /**
     * getProperty - gets the requests property
     * @param $property
     * @return mixed
     */
    public function getProperty($property) {
        $function = 'get' . $property;
        if (method_exists($this, $function)) {
            return $this->$function();
        }
    }


    public function toArray() {
        $reservationArray = array();

        $reservationArray['Title'] = $this->getTitle();
        $reservationArray['FirstName'] = $this->getFirstName();
        $reservationArray['LastName'] = $this->getLastName();
        $reservationArray['EmailAddress'] = $this->getEmailAddress();
        $reservationArray['Mobile'] = $this->getMobile();
        $reservationArray['HomePhone'] = $this->getHomePhone();
        $reservationArray['StreetName'] = $this->getStreetName();
        $reservationArray['City'] = $this->getCity();
        $reservationArray['Postcode'] = $this->getPostcode();
        $reservationArray['StateProvince'] = $this->getStateProvince();
        $reservationArray['Country'] = $this->getCountry();
        $reservationArray['CompanyName'] = $this->getCompanyName();
        $reservationArray['RoomType'] = $this->getRoomType();
        $reservationArray['RoomNumber'] = $this->getRoomNumber();
        $reservationArray['GuestNumberAdults'] = $this->getGuestNumberAdults();
        $reservationArray['GuestNumberChildren'] = $this->getGuestNumberChildren();
        $reservationArray['CheckInDate'] = $this->getCheckInDate();
        $reservationArray['CheckOutDate'] = $this->getCheckOutDate();
        $reservationArray['ArrivalFlightNo'] = $this->getArrivalFlightNo();
        $reservationArray['AirportTransportRequired'] = $this->getAirportTransportRequired();
        $reservationArray['Comments'] = $this->getComments();
        $reservationArray['PaymentMethod'] = $this->getPaymentMethod();

        return $reservationArray;

    }

    /**
     * @return mixed
     */
    public function getAirportTransportRequired()
    {
        return $this->AirportTransportRequired;
    }

    /**
     * @param mixed $AirportTransportRequired
     */
    public function setAirportTransportRequired($AirportTransportRequired)
    {
        $this->AirportTransportRequired = $AirportTransportRequired;
    }

    /**
     * @return mixed
     */
    public function getArrivalFlightNo()
    {
        return $this->ArrivalFlightNo;
    }

    /**
     * @param mixed $ArrivalFlightNo
     */
    public function setArrivalFlightNo($ArrivalFlightNo)
    {
        $this->ArrivalFlightNo = $ArrivalFlightNo;
    }

    /**
     * @return mixed
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }

    /**
     * @param mixed $CheckInDate
     */
    public function setCheckInDate($CheckInDate)
    {
        $this->CheckInDate = $CheckInDate;
    }

    /**
     * @return mixed
     */
    public function getCheckOutDate()
    {
        return $this->CheckOutDate;
    }

    /**
     * @param mixed $CheckOutDate
     */
    public function setCheckOutDate($CheckOutDate)
    {
        $this->CheckOutDate = $CheckOutDate;
    }

    /**
     * @return mixed
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param mixed $City
     */
    public function setCity($City)
    {
        $this->City = $City;
    }

    /**
     * @return mixed
     */
    public function getComments()
    {
        return $this->Comments;
    }

    /**
     * @param mixed $Comments
     */
    public function setComments($Comments)
    {
        $this->Comments = $Comments;
    }

    /**
     * @return mixed
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }

    /**
     * @param mixed $CompanyName
     */
    public function setCompanyName($CompanyName)
    {
        $this->CompanyName = $CompanyName;
    }

    /**
     * @return mixed
     */
    public function getCountry()
    {
        return $this->Country;
    }

    /**
     * @param mixed $Country
     */
    public function setCountry($Country)
    {
        $this->Country = $Country;
    }

    /**
     * @return mixed
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }

    /**
     * @param mixed $EmailAddress
     */
    public function setEmailAddress($EmailAddress)
    {
        $this->EmailAddress = $EmailAddress;
    }

    /**
     * @return mixed
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }

    /**
     * @param mixed $FirstName
     */
    public function setFirstName($FirstName)
    {
        $this->FirstName = $FirstName;
    }

    /**
     * @return mixed
     */
    public function getGuestNumberAdults()
    {
        return $this->GuestNumberAdults;
    }

    /**
     * @param mixed $GuestNumberAdults
     */
    public function setGuestNumberAdults($GuestNumberAdults)
    {
        $this->GuestNumberAdults = $GuestNumberAdults;
    }

    /**
     * @return mixed
     */
    public function getGuestNumberChildren()
    {
        return $this->GuestNumberChildren;
    }

    /**
     * @param mixed $GuestNumberChildren
     */
    public function setGuestNumberChildren($GuestNumberChildren)
    {
        $this->GuestNumberChildren = $GuestNumberChildren;
    }

    /**
     * @return mixed
     */
    public function getHomePhone()
    {
        return $this->HomePhone;
    }

    /**
     * @param mixed $HomePhone
     */
    public function setHomePhone($HomePhone)
    {
        $this->HomePhone = $HomePhone;
    }

    /**
     * @return mixed
     */
    public function getLastName()
    {
        return $this->LastName;
    }

    /**
     * @param mixed $LastName
     */
    public function setLastName($LastName)
    {
        $this->LastName = $LastName;
    }

    /**
     * @return mixed
     */
    public function getMobile()
    {
        return $this->Mobile;
    }

    /**
     * @param mixed $Mobile
     */
    public function setMobile($Mobile)
    {
        $this->Mobile = $Mobile;
    }

    /**
     * @return mixed
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }

    /**
     * @param mixed $PaymentMethod
     */
    public function setPaymentMethod($PaymentMethod)
    {
        $this->PaymentMethod = $PaymentMethod;
    }

    /**
     * @return mixed
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }

    /**
     * @param mixed $Postcode
     */
    public function setPostcode($Postcode)
    {
        $this->Postcode = $Postcode;
    }

    /**
     * @return mixed
     */
    public function getRoomNumber()
    {
        return $this->RoomNumber;
    }

    /**
     * @param mixed $RoomNumber
     */
    public function setRoomNumber($RoomNumber)
    {
        $this->RoomNumber = $RoomNumber;
    }

    /**
     * @return mixed
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }

    /**
     * @param mixed $RoomType
     */
    public function setRoomType($RoomType)
    {
        $this->RoomType = $RoomType;
    }

    /**
     * @return mixed
     */
    public function getStateProvince()
    {
        return $this->StateProvince;
    }

    /**
     * @param mixed $StateProvince
     */
    public function setStateProvince($StateProvince)
    {
        $this->StateProvince = $StateProvince;
    }

    /**
     * @return mixed
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }

    /**
     * @param mixed $StreetName
     */
    public function setStreetName($StreetName)
    {
        $this->StreetName = $StreetName;
    }

    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->Title;
    }

    /**
     * @param mixed $Title
     */
    public function setTitle($Title)
    {
        $this->Title = $Title;
    }




}

?>



