$( document ).ready(function() {

    var startDate = new Date();
    var FromEndDate = new Date();

    $('.checkindate').datepicker({
        format: "dd/mm/yyyy",
        todayHighlight: true,
        startDate: '+0d',
        autoclose: true
    }).on('changeDate', function(selected){
        startDate = new Date(selected.date.valueOf() + 1000*3600*24);
        startDate.setDate(startDate.getDate(new Date(selected.date.valueOf())));
        $('.checkoutdate').datepicker('setStartDate', startDate);
    });

    $('.checkoutdate').datepicker({
        todayHighlight: true,
        format: "dd/mm/yyyy",
        startDate: '+1d',
        autoclose: true
    }).on('changeDate', function(selected){
        FromEndDate = new Date(selected.date.valueOf() - 1000*3600*24);
        FromEndDate.setDate(FromEndDate.getDate(new Date(selected.date.valueOf())));
        $('.checkindate').datepicker('setEndDate', FromEndDate);
    });

    $('#reservationForm').bootstrapValidator({
        // To use feedback icons, ensure that you use Bootstrap v3.1.0 or later
        feedbackIcons: {
            valid: 'glyphicon glyphicon-ok',
            invalid: 'glyphicon glyphicon-remove',
            validating: 'glyphicon glyphicon-refresh'
        },
        fields: {
            FirstName: {
                message: 'First Name is not valid',
                validators: {
                    notEmpty: {
                        message: 'Your First Name is required and cannot be empty'
                    },
                    regexp: {
                        regexp: /^[-a-zA-Z ]+$/,
                        message: 'Your First Name can only consist of letters, dashes or spaces'
                    }
                }
            },
            LastName: {
                message: 'Last Name is not valid',
                validators: {
                    notEmpty: {
                        message: 'Your Last Name is required and cannot be empty'
                    },
                    regexp: {
                        regexp: /^[-a-zA-Z ]+$/,
                        message: 'Your Last Name can only consist of letters, dashes or spaces'
                    }
                }
            },
            EmailAddress: {
                trigger: 'blur',
                message: 'Your email address is required',
                validators: {
                    notEmpty: {
                        message: 'Your Email Address is required and cannot be empty'
                    },
                    emailAddress: {
                        message: 'This is not a valid email address'
                    }
                }
            },
            Mobile: {
                validators: {
                    notEmpty: {
                        message: 'A contact number is required'
                    },
                    regexp: {
                        regexp: /^[0-9 ]+$/,
                        message: 'The contact number is can only consist of numbers or spaces'
                    }
                }
            },
            StreetName: {
                message: 'Street Name and Number is required',
                validators: {
                    notEmpty: 'Street Name and Number is required'
                }
            },
            City: {
                message: 'City name is required',
                validators: {
                    notEmpty: 'City name is required'
                }
            },
            Postcode: {
                message: 'Postcode/Zip is required',
                validators: {
                    notEmpty: 'Postcode/Zip is required'
                }
            },
            StateProvince: {
                message: 'State/Province is required',
                validators: {
                    notEmpty: 'State/Province is required'
                }
            },
            CheckInDate: {
                trigger: 'change',
                validators: {
                    notEmpty: {
                        message: 'Check-in date is required'
                    },
                    date: {
                        format: 'DD/MM/YYYY',
                        message: 'The value is not a valid date'
                    }

                }
            },
            CheckOutDate: {
                trigger: 'change',
                validators: {
                    notEmpty: {
                        message: 'Check-out date is required'
                    },
                    date: {
                        format: 'DD/MM/YYYY',
                        message: 'The value is not a valid date'
                    }

                }
            }

        }
    });

});