/*
 * Notes on hue
 *
 * This script uses hue rotation in the following manner:
 * hue=0   is red (#FF0000)
 * hue=60  is yellow (#FFFF00)
 * hue=120 is green (#00FF00)
 * hue=180 is cyan (#00FFFF)
 * hue=240 is blue (#0000FF)
 * hue=300 is magenta (#FF00FF)
 * hue=360 is hue=0 (#FF0000)
 *
 * Notes on the script
 *
 * This script should function in any browser that supports document.getElementById
 * It has been tested in Netscape7, Mozilla Firefox 1.0, and Internet Explorer 6
 *
 * Accessibility
 *
 * The script does not write the string out, but rather takes it from an existing
 * HTML element. Therefore, users with javascript disabled will not be adverely affected.
 * They just won't get the pretty colors.
 */

/*
 * splits par.firstChild.data into 1 span for each letter
 * ARGUMENTS
 *   span - HTML element containing a text node as the only element
 */
function toSpans(span) {
  var str=span.firstChild.data;
  var a=str.length;
  span.removeChild(span.firstChild);
  for(var i=0; i<a; i++) {
    var theSpan=document.createElement("SPAN");
    theSpan.appendChild(document.createTextNode(str.charAt(i)));
    span.appendChild(theSpan);
  }
}

/*
 * creates a rainbowspan object
 * whose letters will be colored [deg] degrees of hue
 * ARGUMENTS
 *   span - HTML element to apply the effect to (text only, no HTML)
 *   hue - what degree of hue to start at (0-359)
 *   deg - how many hue degrees should be traversed from beginning to end of the string (360 => once around, 720 => twice, etc)
 *   brt - brightness (0-255, 0 => black, 255 => full color)
 *   spd - how many ms between moveRainbow calls (less => faster)
 *   hspd - how many hue degrees to move every time moveRainbow is called (0-359, closer to 180 => faster)
 */
function RainbowSpan(span, hue, deg, brt, spd, hspd) {
    this.deg=(deg==null?360:Math.abs(deg));
    this.hue=(hue==null?0:Math.abs(hue)%360);
    this.hspd=(hspd==null?3:Math.abs(hspd)%360);
    this.length=span.firstChild.data.length;
    this.span=span;
    this.speed=(spd==null?50:Math.abs(spd));
    this.hInc=this.deg/this.length;
    this.brt=(brt==null?255:Math.abs(brt)%256);
    this.timer=null;
    toSpans(span);
    this.moveRainbow();
}

/*
 * sets the colors of the children of [this] as a hue-rotating rainbow starting at this.hue;
 * requires something to manage ch externally
 * I had to make the RainbowSpan class because M$IE wouldn't let me attach this prototype to [Object]
 */
RainbowSpan.prototype.moveRainbow = function() {
  if(this.hue>359) this.hue-=360;
  var color;
  var b=this.brt;
  var a=this.length;
  var h=this.hue;

  for(var i=0; i<a; i++) {

    if(h>359) h-=360;

    if(h<60) { color=Math.floor(((h)/60)*b); red=b;grn=color;blu=0; }
    else if(h<120) { color=Math.floor(((h-60)/60)*b); red=b-color;grn=b;blu=0; }
    else if(h<180) { color=Math.floor(((h-120)/60)*b); red=0;grn=b;blu=color; }
    else if(h<240) { color=Math.floor(((h-180)/60)*b); red=0;grn=b-color;blu=b; }
    else if(h<300) { color=Math.floor(((h-240)/60)*b); red=color;grn=0;blu=b; }
    else { color=Math.floor(((h-300)/60)*b); red=b;grn=0;blu=b-color; }

    h+=this.hInc;

    this.span.childNodes[i].style.color="rgb("+red+", "+grn+", "+blu+")";
  }
  this.hue+=this.hspd;
}
function getLongDateString()
{	//method defined on class Date.
	//Returns a date string of the form: Day DD Month,YYYY
	//(e.g. Sunday 27 September, 1998)
	monthNames = new Array("January","February","March","April","May","June","July","August","September","October","November","December");
dayNames = new Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
	dayOfWeek = this.getDay();
	day = dayNames[dayOfWeek];
	dateOfMonth = this.getDate();
monthNo = this.getMonth();
	month = monthNames[monthNo];
year = this.getYear();
	if (year < 2000)
year = year + 1900;
dateStr = day+" "+dateOfMonth+" "+month+", "+year;
	return dateStr;
}
//register the  method in the class Date
Date.prototype.getLongDateString=getLongDateString;

function DocDate()
{ //return the document modification date (excl.time)
//as a string
	DateTimeStr = document.lastModified;
	secOffset = Date.parse(DateTimeStr);
	if (secOffset == 0 || secOffset == null) //Opera3.2
			 dateStr = "Unknown";
	else
	{
		aDate = new Date();
		aDate.setTime(secOffset);
		//use method defined above
		datestr = aDate.getLongDateString();
	}
	return dateStr;
}
/***********************************************
* Bookmark site script-  Dynamic Drive DHTML code library (www.dynamicdrive.com)
* This notice MUST stay intact for legal use
* Visit Dynamic Drive at http://www.dynamicdrive.com/ for full source code
***********************************************/

function bookmarksite(title, url){
if (document.all)
window.external.AddFavorite(url, title);
else if (window.sidebar)
window.sidebar.addPanel(title, url, "")
}


function clearText(thefield){
if (thefield.defaultValue==thefield.value)
thefield.value = ""
} 


// Script Source: CodeLifter.com
// Copyright 2003
// Do not remove this notice.

// SETUPS:
// ===============================

// Set the horizontal and vertical position for the popup

PositionX = 300;
PositionY = 300;

// Set these value approximately 20 pixels greater than the
// size of the largest image to be used (needed for Netscape)

defaultWidth  = 420;
defaultHeight = 300;

// Set autoclose true to have the window close automatically
// Set autoclose false to allow multiple popup windows

var AutoClose = true;

// Do not edit below this line...
// ================================
if (parseInt(navigator.appVersion.charAt(0))>=4){
var isNN=(navigator.appName=="Netscape")?1:0;
var isIE=(navigator.appName.indexOf("Microsoft")!=-1)?1:0;}
var optNN='scrollbars=no,width='+defaultWidth+',height='+defaultHeight+',left='+PositionX+',top='+PositionY;
var optIE='scrollbars=no,width=150,height=100,left='+PositionX+',top='+PositionY;
function popImage(imageURL,imageTitle){
if (isNN){imgWin=window.open('about:blank','',optNN);}
if (isIE){imgWin=window.open('about:blank','',optIE);}
with (imgWin.document){
writeln('<html><head><title>Loading...</title><style>body{margin:0px;}</style>');writeln('<sc'+'ript>');
writeln('var isNN,isIE;');writeln('if (parseInt(navigator.appVersion.charAt(0))>=4){');
writeln('isNN=(navigator.appName=="Netscape")?1:0;');writeln('isIE=(navigator.appName.indexOf("Microsoft")!=-1)?1:0;}');
writeln('function reSizeToImage(){');writeln('if (isIE){');writeln('window.resizeTo(100,100);');
writeln('width=100-(document.body.clientWidth-document.images[0].width);');
writeln('height=100-(document.body.clientHeight-document.images[0].height);');
writeln('window.resizeTo(width,height);}');writeln('if (isNN){');       
writeln('window.innerWidth=document.images["George"].width;');writeln('window.innerHeight=document.images["George"].height;}}');
writeln('function doTitle(){document.title="'+imageTitle+'";}');writeln('</sc'+'ript>');
if (!AutoClose) writeln('</head><body bgcolor="#990000"scroll="no" onload="reSizeToImage();doTitle();self.focus()" background="images/bgmain.gif" text="#0F0000" alink="#0F0000" vlink="#0F0000" link="#0F0000">')
else writeln('</head><body bgcolor=000000 scroll="no" onload="reSizeToImage();doTitle();self.focus()" onblur="self.close()">');
writeln('<img name="George" src='+imageURL+' style="display:block"></body></html>');
close();		
}}

var focused = false;
function clearText(thefield){ if (thefield.defaultValue == thefield.value) { thefield.value = ""; }}
function check(thefield) { if (thefield.value == "") { thefield.value = thefield.defaultValue; }}
function defaultColor() {
document.getElementById('t_name').className = "normal";
document.getElementById('t_address').className = "normal";
document.getElementById('t_contact').className = "normal";  
document.getElementById('t_credit_card').className = "normal";
document.getElementById('t_hotel').className = "normal";
document.getElementById('t_reservation').className = "normal"; 
document.getElementById('i_fname').className = "black";
document.getElementById('i_lname').className = "black";
document.getElementById('i_email').className = "black";
document.getElementById('i_phone').className = "black";
document.getElementById('i_street').className = "black"; 
document.getElementById('i_city').className = "black";
document.getElementById('i_zip').className = "black";
document.getElementById('i_state').className = "black";
document.getElementById('i_ccname').className = "black";
document.getElementById('i_ccnum').className = "black";
}
function formvalidation(frm) { 
  defaultColor();
  var error = ""; 
  error += checkPersonal(frm); 
  error += checkReservation(frm); 
  error += checkPayment(frm); 
  if (error == "") { 
    return true; 
  } else { 
    alert(error); 
    return false; 
  } 
}
function checkPayment(frm) { 
  var err = ""; 
    if (frm.paymentType[3].checked == true) { 
      if (frm.creditName.value == frm.creditName.defaultValue) { 
        err += "Please enter your Full Name on your Credit Card.\n"; 
        document.getElementById('t_credit_card').className = "highlight";
        document.getElementById('i_ccname').className = "highlight";
      } 
      if (frm.creditNum.value == frm.creditNum.defaultValue) { 
        err += "Please enter your Credit Card Number.\n"; 
        document.getElementById('t_credit_card').className = "highlight";
        document.getElementById('i_ccnum').className = "highlight"; 
      } 
    }    
    return err; 
}
function checkReservation(frm) { 
  var err = "";
  var dateErr = false;
  checkInStr = frm.inputCheckIn.value; 
  checkOutStr = frm.inputCheckOut.value;
  if (checkInStr == "Click Icon") { 
    err += "Please enter a Check-In Date\n";
    document.getElementById('i_checkin').className = "highlight";  
    dateErr = true;
  } 
  if (checkOutStr == "Click Icon") { 
    err += "Please enter a Check-Out Date\n";
    document.getElementById('i_checkout').className = "highlight"; 
    dateErr = true;
  } 
  In = checkInStr.split("/"); 
  Out = checkOutStr.split("/"); 
  inDate = new Date(In[2], In[1]-1, In[0]); 
  outDate = new Date(Out[2], Out[1]-1, Out[0]); 
  Today = new Date();
  if (outDate <= inDate) { 
    err += "Please verify Check-In Date is later than Check-Out Date\n"; 
    dateErr = true;
    document.getElementById('i_checkin').className = "highlight"; 
    document.getElementById('i_checkout').className = "highlight"; 
  } 
  if (inDate <= Today || outDate <= Today) {
    err += "Please verify dates are later than today.\n";
    dateErr = true;
    document.getElementById('i_checkin').className = "highlight"; 
    document.getElementById('i_checkout').className = "highlight"; 
  }
  
  if (dateErr) {
    document.getElementById('t_reservation').className = "highlight";    
  }
  
  if (frm.hotels.value == "blank.html") {
    err += "Please select a Hotel.\n";
    document.getElementById('t_hotel').className = "highlight";  
  }
  return err; 
}
function checkPersonal(frm) { 
  var err = ""; 
  if (frm.FName.value == frm.FName.defaultValue) { 
    err += "Please enter your First Name.\n"; 
    document.getElementById('t_name').className = "highlight";
    document.getElementById('i_fname').className = "highlight";  
 }
  if (frm.LName.value == frm.LName.defaultValue) { 
    err += "Please enter your Last Name.\n"; 
    document.getElementById('t_name').className = "highlight"; 
    document.getElementById('i_lname').className = "highlight";
 }
  if (frm.Email.value == frm.Email.defaultValue) { 
    err += "Please enter your Email Address.\n"; 
    document.getElementById('t_contact').className = "highlight";
    document.getElementById('i_email').className = "highlight";   
 }
  if (frm.Phone.value == frm.Phone.defaultValue) { 
    err += "Please enter your Home Phone Number.\n"; 
    document.getElementById('t_contact').className = "highlight";
    document.getElementById('i_phone').className = "highlight";   
 }
  if (frm.Address.value == frm.Address.defaultValue) { 
    err += "Please enter your Street Name & Number.\n"; 
    document.getElementById('t_address').className = "highlight";
    document.getElementById('i_street').className = "highlight";  
 }
  if (frm.City.value == frm.City.defaultValue) { 
    err += "Please enter your City.\n"; 
    document.getElementById('t_address').className = "highlight";
    document.getElementById('i_city').className = "highlight"; 
    }
  if (frm.Zip.value == frm.Zip.defaultValue) { 
    err += "Please enter your Zip/Postcode.\n"; 
    document.getElementById('t_address').className = "highlight";
    document.getElementById('i_zip').className = "highlight";  
    }
  if (frm.State.value == frm.State.defaultValue) { 
    err += "Please enter your State.\n"; 
    document.getElementById('t_address').className = "highlight";
    document.getElementById('i_state').className = "highlight";  
    }
  return err; }
  
function Navigate() {
var number = NavSelect.selectedIndex;
location.href = NavSelect.options[number].value; }
