<?php

class Emailer {

    protected $_mailer;   /* PHPMailer class - class that sends out the emails */
    protected $_mailDetails;
    /**
     * __construct - sets defaults
     */
    public function __construct() {

        $this->_mailer = new PHPMailer();
        $this->setEMailDefaults();
    }

    /**
     * setEMailDefaults - sets PHPMailer default email details, host, port etc
     */
    private function setEMailDefaults() {
        $this->_mailDetails = new MailDetails();

        $this->_mailer->SMTPAuth   = false;
        $this->_mailer->Host       = MailDetails::MAIL_HOST;
        $this->_mailer->Port       = MailDetails::MAIL_PORT;
        $this->_mailer->setFrom(MailDetails::FROM_EMAIL, MailDetails::FROM_NAME);
        $this->_mailer->addReplyTo(MailDetails::FROM_EMAIL, MailDetails::FROM_NAME);
        $this->_mailer->isHTML(true);
    }

    /**
     * sendEmail - send email
     * @param string - Email subject
     * @param string - HEML version of email body
     * @param string - Text version of email body
     * @param string - Recipient name
     * @param string - Recipient email address
     * @return bool - true if send successful, false if not successful
     */
    public function sendEmail($subject, $body_html, $body_alt, $recipient_name, $recipient_email_address) {
        $this->_mailer->Subject = $subject;
        $this->_mailer->Body    = $body_html;
        $this->_mailer->AltBody = $body_alt;
        $this->_mailer->addAddress($recipient_email_address, $recipient_name);
        return $this->_mailer->send();
    }

}

?>
