<?php

/**
 * SPL autoloader.
 * @param string - The name of the class to load
 */
function ClassesAutoload($class_name) {



    $directories = array(str_replace('config', 'classes/', dirname(__FILE__)), dirname(__FILE__) . '/');

    foreach($directories as $directory) {
        if(is_readable($directory . 'class.' . $class_name . '.php')) {
            require_once($directory . 'class.' . $class_name . '.php');
            return;
        }
    }

}

if (version_compare(PHP_VERSION, '5.1.2', '>=')) {
    //SPL autoloading was introduced in PHP 5.1.2
    if (version_compare(PHP_VERSION, '5.3.0', '>=')) {
        spl_autoload_register('ClassesAutoload', true, true);
    } else {
        spl_autoload_register('ClassesAutoload');
    }
} else {
    /**
     * Fall back to traditional autoload for old PHP versions
     * @param string - The name of the class to load
     */
    function __autoload($classname)
    {
        ClassesAutoload($classname);
    }
}

?>