
<h1>Online Reservation</h1>
<p class="note">Please complete all fields so we can server you better!</p>


<form id="reservationForm" class="form-horizontal" role="form" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"], ENT_QUOTES, "utf-8"); ?>" method="post">
<fieldset>
    <legend>Personal Details</legend>

    <div class="form-group form-group-sm">
        <label for="Title" class="col-md-4 control-label">Title *</label>
        <div class="col-md-2">
            <select name="Title" class="form-control">
                <option value="Mr">Mr</option>
                <option value="Mrs">Mrs</option>
                <option value="Miss">Miss</option>
                <option value="Dr">Dr</option>
            </select>
        </div>
    </div>

    <div class="form-group">
        <label for="FirstName" class="col-sm-4 control-label">First Name *</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" name="FirstName" placeholder="First Name" value="<?php echo $worker->getFieldPOSTValue('FirstName'); ?>"/>
        </div>

        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('FirstName') ? $worker->failedValidationMessage('FirstName') : ''); } ?>

    </div>
    <div class="form-group">
        <label for="LastName" class="col-sm-4 control-label">Last Name *</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" name="LastName" placeholder="Last Name" value="<?php echo $worker->getFieldPOSTValue('LastName'); ?>" />
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('LastName') ? $worker->failedValidationMessage('LastName') : ''); } ?>
    </div>

    <div class="form-group">
        <label for="EmailAddress" class="col-sm-4 control-label">Email Address *</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" name="EmailAddress" placeholder="Email Address" value="<?php echo $worker->getFieldPOSTValue('EmailAddress'); ?>" />
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('EmailAddress') ? $worker->failedValidationMessage('EmailAddress') : ''); } ?>
    </div>

    <div class="form-group">
        <label for="Mobile" class="col-sm-4 control-label">Mobile Number *</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" name="Mobile" placeholder="Mobile Phone Number" value="<?php echo $worker->getFieldPOSTValue('Mobile'); ?>" />
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('Mobile') ? $worker->failedValidationMessage('Mobile') : ''); } ?>
    </div>

    <div class="form-group">
        <label for="HomePhone" class="col-sm-4 control-label">Home Phone</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" name="HomePhone" placeholder="Home Phone Number" value="<?php echo $worker->getFieldPOSTValue('HomePhone'); ?>" />
        </div>
    </div>

    <div class="form-group">
        <label for="StreetName" class="col-sm-4 control-label">Address *</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" name="StreetName" placeholder="Street Name &amp; Number" value="<?php echo $worker->getFieldPOSTValue('StreetName'); ?>" />
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('StreetName') ? $worker->failedValidationMessage('StreetName') : ''); } ?>
    </div>

    <div class="form-group">
        <div class="col-sm-offset-4 col-sm-6">
            <input type="text" class="form-control" name="City" placeholder="City" value="<?php echo $worker->getFieldPOSTValue('City'); ?>" />
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('City') ? $worker->failedValidationMessage('City') : ''); } ?>
    </div>

    <div class="form-group">
        <div class="col-sm-offset-4 col-sm-6">
            <input type="text" class="form-control" name="Postcode" placeholder="Postcode" value="<?php echo $worker->getFieldPOSTValue('Postcode'); ?>" />
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('Postcode') ? $worker->failedValidationMessage('Postcode') : ''); } ?>
    </div>

    <div class="form-group">
        <div class="col-sm-offset-4 col-sm-6">
            <input type="text" class="form-control" name="StateProvince" placeholder="State/Province" value="<?php echo $worker->getFieldPOSTValue('StateProvince'); ?>" />
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('StateProvince') ? $worker->failedValidationMessage('StateProvince') : ''); } ?>
    </div>



    <div class="form-group">

        <div class="col-sm-offset-4 col-sm-6">
            <select name="Country" class="form-control">
                <?php
                $countries = file_get_contents('assets/library/loc.txt');
                $countriesArray = explode("\n", $countries);

                foreach ($countriesArray as $key => $countryName) {
                    if ($worker->isPost()) {
                        $selected = trim($countryName) == $worker->getFieldPOSTValue('Country') ? "selected" : "";
                    } else {
                        $selected = trim($countryName) == "Papua New Guinea" ? "selected" : "";
                    }
                    echo '<option value="' . $countryName . '"' . $selected . '>' . $countryName . '</option>';
                }

                ?>
            </select>
        </div>
    </div>

    <div class="form-group">
        <label for="CompanyName" class="col-sm-4 control-label">Company Name</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" name="CompanyName" placeholder="Company Name" value="<?php echo $worker->getFieldPOSTValue('CompanyName'); ?>" />
        </div>
    </div>

</fieldset>

<fieldset>
    <legend>Reservation Details</legend>

    <div class="form-group">
        <label for="RoomType" class="col-sm-4 control-label">Room Type *</label>
        <div class="col-sm-6">
            <select name="RoomType" class="form-control">
                <option value="Budget" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('RoomType') == 'Budget') ? 'selected' : ''; ?>> Budget Room</option>
                <option value="Standard" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('RoomType') == 'Standard') ? 'selected' : ''; ?>> Standard Room</option>
                <option value="Deluxe" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('RoomType') == 'Deluxe') ? 'selected' : ''; ?>> Deluxe Room</option>
                <option value="King" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('RoomType') == 'King') ? 'selected' : ''; ?>> Executive King Room</option>
            </select>
        </div>
    </div>

    <div class="form-group">
        <label for="RoomNumber" class="col-sm-4 control-label">No. of Rooms *</label>
        <div class="col-sm-2">
            <select name="RoomNumber" class="form-control">
                <option value="1" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('RoomNumber') == '1') ? 'selected' : ''; ?>>1</option>
                <option value="2" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('RoomNumber') == '2') ? 'selected' : ''; ?>>2</option>
                <option value="3" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('RoomNumber') == '3') ? 'selected' : ''; ?>>3</option>
            </select>
        </div>
    </div>

    <div class="form-group">
        <label for="GuestNumber" class="col-sm-4 control-label">No. of Guests *</label>
        <div class="col-sm-2">
            <select name="GuestNumberAdults" class="form-control">
                <option value="1" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberAdults') == '1') ? 'selected' : ''; ?>>1</option>
                <option value="2" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberAdults') == '2') ? 'selected' : ''; ?>>2</option>
                <option value="3" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberAdults') == '3') ? 'selected' : ''; ?>>3</option>
                <option value="4" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberAdults') == '4') ? 'selected' : ''; ?>>4</option>
                <option value="5" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberAdults') == '5') ? 'selected' : ''; ?>>5</option>
                <option value="6" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberAdults') == '6') ? 'selected' : ''; ?>>6</option>
            </select>
        </div>
        <p class="form-control-static"> Adults </p>

    </div>
    <div class="form-group">
        <div class="col-sm-offset-4 col-sm-2">
            <select name="GuestNumberChildren" class="form-control">
                <option value="0" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberChildren') == '0') ? 'selected' : ''; ?>>0</option>
                <option value="1" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberChildren') == '1') ? 'selected' : ''; ?>>1</option>
                <option value="2" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberChildren') == '2') ? 'selected' : ''; ?>>2</option>
                <option value="3" <?php echo ($worker->isPost() && $worker->getFieldPOSTValue('GuestNumberChildren') == '3') ? 'selected' : ''; ?>>3</option>
            </select>
        </div>
        <p class="form-control-static"> Children </p>
    </div>

    <div class="form-group">
        <label for="CheckInDate" class="col-sm-4 control-label">Check-In Date *</label>
        <div class="col-sm-6" id="CheckInDate">
            <input type="text" name="CheckInDate" type="text" class="form-control checkindate" placeholder="DD/MM/YYYY" value="<?php echo $worker->getFieldPOSTValue('CheckinDate'); ?>" />
            <p class="help-block">Click to select check-in date.</p>
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('CheckInDate') ? $worker->failedValidationMessage('CheckInDate') : ''); } ?>
    </div>

    <div class="form-group">
        <label for="CheckOutDate" class="col-sm-4 control-label">Check-Out Date *</label>
        <div class="col-sm-6" id="CheckOutDate">
            <input type="text" name="CheckOutDate" type="text" class="form-control checkoutdate" placeholder="DD/MM/YYYY" value="<?php echo $worker->getFieldPOSTValue('CheckOutDate'); ?>" />
            <p class="help-block">Click to select check-out date.</p>
        </div>
        <?php if ($worker->isPost()) { echo ($worker->fieldFailedValidation('CheckOutDate') ? $worker->failedValidationMessage('CheckOutDate') : ''); } ?>
    </div>

    <div class="form-group">
        <label for="ArrivalFlightNo" class="col-sm-4 control-label">Arrival Flight No.</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" name="ArrivalFlightNo" placeholder="Arrival Flight No." value="<?php echo $worker->getFieldPOSTValue('ArrivalFlightNo'); ?>" />
        </div>
    </div>

    <div class="form-group">
        <label for="ArrivalFlightNo" class="col-sm-4 control-label">Airport Transport Required</label>
        <div class="col-sm-6">
            <div class="radio">
                <label>
                    <input type="radio" name="AirportTransportRequired" value="No" checked>
                    No transport from Airport required, thanks.
                </label>
            </div>
            <div class="radio">
                <label>
                    <input type="radio" name="AirportTransportRequired" value="Yes">
                    Yes, organise transport from the Airport.
                </label>
            </div>
        </div>
    </div>

    <div class="form-group">
        <label for="Comments" class="col-sm-4 control-label">Comments</label>
        <div class="col-sm-6">
            <textarea class="form-control" rows="3" name="Comments"><?php echo $worker->getFieldPOSTValue('Comments'); ?></textarea>
        </div>
    </div>

</fieldset>

<fieldset>
    <legend>Payment Method</legend>

    <div class="form-group">
        <label for="PaymentMethond" class="col-sm-4 control-label">Select Payment Method</label>
        <div class="col-sm-6">
            <div class="radio">
                <label>
                    <input type="radio" name="PaymentMethod" value="Credit Card" checked>
                    Pay by Credit Card
                </label>
            </div>
            <div class="radio">
                <label>
                    <input type="radio" name="PaymentMethod" value="Cash">
                    Pay by Cash
                </label>
            </div>
            <div class="radio">
                <label>
                    <input type="radio" name="PaymentMethod" value="Company Order">
                    Pay by Company Order (authorised)
                </label>
            </div>
            <div class="radio">
                <label>
                    <input type="radio" name="PaymentMethod" value="Telegraphic Transfer">
                    Pay by Telegraphic Transfer
                </label>
            </div>
        </div>
    </div>

</fieldset>

<div class="form-group">
    <div class="col-sm-offset-4 col-sm-5">
        <button type="submit" class="btn btn-default btn-block" name="Continue">Continue Booking ...</button>
    </div>
</div>

</form>